const axios = require('axios');
const config = require("../config/config.json");

const FB_PAGE_ACCESS_TOKEN = config.FB_PAGE_ACCESS_TOKEN;

if (!FB_PAGE_ACCESS_TOKEN) {
  console.warn('Warning: FB_PAGE_ACCESS_TOKEN is not set');
}

/**
 * Sends a text message to a Facebook user via Graph API
 * @param {string} recipientId - The Facebook user ID (sender ID)
 * @param {string} text - The message text to send
 * @returns {Promise<void>}
 */
async function sendMessageToUser(recipientId, text) {
  if (!FB_PAGE_ACCESS_TOKEN) {
    throw new Error('FB_PAGE_ACCESS_TOKEN is not configured');
  }

  const url = `https://graph.facebook.com/v18.0/me/messages?access_token=${FB_PAGE_ACCESS_TOKEN}`;

  const payload = {
    recipient: { id: recipientId },
    message: { text: text },
  };

  try {
    const response = await axios.post(url, payload, {
      headers: {
        'Content-Type': 'application/json',
      },
    });

    console.log('Message sent successfully:', response.data);
  } catch (error) {
    console.error('Error sending message to Facebook:');
    console.error('Status:', error.response?.status);
    console.error('Data:', error.response?.data);
    console.error('Message:', error.message);
    throw error;
  }
}

module.exports = { sendMessageToUser };

