const express = require('express');
const router = express.Router();
const { handleIncomingMessage } = require('../services/handler');
const config = require("../config/config.json");
const FB_VERIFY_TOKEN = config.FB_VERIFY_TOKEN;


/**
 * GET /webhook - Webhook verification for Facebook
 * Facebook will call this to verify the webhook endpoint
 */
router.get('/webhook', (req, res) => {
  const mode = req.query['hub.mode'];
  const token = req.query['hub.verify_token'];
  const challenge = req.query['hub.challenge'];

  if (mode === 'subscribe' && token === FB_VERIFY_TOKEN) {
    console.log('WEBHOOK_VERIFIED');
    res.status(200).send(challenge);
  } else {
    console.error('Webhook verification failed');
    res.sendStatus(403);
  }
});

/**
 * POST /webhook - Receives incoming messages from Facebook Messenger
 * Processes messages and triggers the handler
 */
router.post('/webhook', async (req, res) => {
  try {
    const body = req.body;

    // Check if this is a page event
    if (body.object === 'page') {
      // Process each entry
      for (const entry of body.entry) {
        const messaging = entry.messaging;

        if (messaging && Array.isArray(messaging)) {
          for (const event of messaging) {
            const senderId = event.sender?.id;

            // Check if this is a text message
            if (event.message && event.message.text && senderId) {
              const userText = event.message.text;
              console.log(`Received message from ${senderId}: ${userText}`);

              // Handle the message asynchronously (don't wait for it)
              handleIncomingMessage(senderId, userText).catch((error) => {
                console.error('Error handling message:', error);
              });
            }
          }
        }
      }

      // Return 200 immediately to acknowledge receipt
      res.status(200).send('EVENT_RECEIVED');
    } else {
      // Not a page event
      res.sendStatus(404);
    }
  } catch (error) {
    console.error('Error processing webhook:', error);
    res.status(500).send('Internal Server Error');
  }
});

module.exports = router;

