const { VertexAI } = require("@google-cloud/vertexai");
const config = require("./config.json");

// Initialize Vertex AI clientطط
const projectId = config.GCLOUD_PROJECT_ID;
const location = config.GCLOUD_LOCATION || "us-central1";

if (!projectId) {
  throw new Error("GCLOUD_PROJECT_ID environment variable is required");
}

// Create Vertex AI instance
const vertexAI = new VertexAI({ project: projectId, location: location });

// Initialize the generative model
const model = vertexAI.getGenerativeModel({
  model: "gemini-1.5-flash",
});

/**
 * Sends a prompt to Vertex AI (Gemini) and returns the generated response
 * @param {string} prompt - The prompt to send to the model
 * @returns {Promise<string>} - The generated text response
 * @throws {Error} - If Vertex AI API fails
 */
async function askVertex(prompt) {
  try {
    const request = {
      contents: [{ role: "user", parts: [{ text: prompt }] }],
    };

    const result = await model.generateContent(request);
    const response = result.response;

    if (response.candidates && response.candidates.length > 0) {
      const candidate = response.candidates[0];
      if (
        candidate.content &&
        candidate.content.parts &&
        candidate.content.parts.length > 0
      ) {
        const text = candidate.content.parts[0].text;
        return text ? text.trim() : "";
      }
    }

    return "";
  } catch (error) {
    console.error("VertexAI error:", error.message);
    console.error("Full error:", error);
    throw new Error("VertexAI error: " + error.message);
  }
}

module.exports = { askVertex };
