const express = require("express");
const webhookRouter = require("./src/routes/webhook");
const testRouter = require("./src/routes/test");
require("dotenv").config();

const app = express();

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

app.get("/", (req, res) => {
  res.json({
    status: "ok",
    message: "fb-vertex-bot running",
    endpoints: {
      health: "GET /",
      webhook: "GET/POST /webhook",
      test: "GET /test",  
    },
  });
});

app.use("/webhook", webhookRouter);
app.use("/test", testRouter);

// برای Fly.io: از environment variables استفاده کنید
const PORT = process.env.PORT || 3000;

app.listen(PORT, "0.0.0.0", () => {
  console.log(`Server running on port ${PORT}`);
  console.log(`Environment: ${process.env.NODE_ENV || "development"}`);
});